/////////////////////////////////////////////////////////////////
//
//	LZElzedPublic.h
//
//	Part of the LZ Kernel
//
//	Copyright (c) 2000-2009 by R R Le Cropane
//	All Rights Reserved
//
/////////////////////////////////////////////////////////////////

#ifndef __LZElzedPublic__
#define __LZElzedPublic__

/////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////

#ifndef ELZED_CALL_TYPE
	#ifdef WIN32
		#define ELZED_CALL_TYPE __stdcall
	#else
		#define ELZED_CALL_TYPE
	#endif
#endif	// ELZED_CALL_TYPE

#ifndef ELZED_API
	#ifdef WIN32
		#ifdef ELZED_SHARED
			#ifdef ELZEDDLL_EXPORTS
				#define ELZED_API __declspec(dllexport)
			#else
				#define ELZED_API __declspec(dllimport)
			#endif	// ELZEDDLL_EXPORTS
		#else
			#define ELZED_API
		#endif	// ELZED_SHARED
	#else
		#define ELZED_API
	#endif	// WIN32
#endif	// ELZED_API


/////////////////////////////////////////////////////////////////
//	Type Definitions
/////////////////////////////////////////////////////////////////

typedef unsigned long long LZObjectHandle;
typedef long (ELZED_CALL_TYPE *ExtOpFunction)(LZObjectHandle);
typedef void (ELZED_CALL_TYPE *ErrorFunction)(long);


/////////////////////////////////////////////////////////////////
//	Constants
/////////////////////////////////////////////////////////////////

// Contexts
const LZObjectHandle kNullHandle = 0;

// Scope codes
const char kCosmicScope = 'C';
const char kGlobalScope = 'G';
const char kLocalScope = 'L';
const char kDefaultScope = 'D';
const char kAnyScope = 'A';

// Complexity Codes
const char kSimpleComplexity = 'S';
const char kComplexComplexity = 'C';
const char kDefaultComplexity = 'D';

// Number base codes
const char kBase2 = 'B';
const char kBase8 = 'O';
const char kBase10 = 'D';
const char kBase12 = 'T';
const char kBase16 = 'H';

// Radix Mark codes
const char kRadixPeriod = 'P';
const char kRadixComma = 'C';

// Formatted result precison limit
const int kDefaultPrecisionLimit = 12;	// 'int' type because of sprintf...

// Quote mark codes
const char kQuoteSingle = '1';
const char kQuoteDouble = '2';

// Angle unit codes
const char kAngleRadians = 'R';
const char kAngleDegrees = 'D';
const char kAngleGrads = 'G';
const char kAngleMillicles = 'M';

// Boolean True codes
const char kTrueOne = 'C';
const char kTrueNegOne = 'N';

// Coordinate format codes
const char kCoordRect = 'R';
const char kCoordPolar = 'P';

// Result data type codes
const char kTypeComp = 'C';
const char kTypeNum = 'N';
const char kTypeStr = 'S';
const char kTypeBool = 'B';
const char kTypeNone = 'X';

// Operator types
const char kOpPrefix[] = "prefix";
const char kOpInfix[] = "infix";
const char kOpPostfix[] = "postfix";
const char kOpNofix[] = "nofix";

#endif	// __LZElzedPublic__